const { Schema, model, mongoose } = require("mongoose");

const beneficiaryModel = new Schema(
  {
    uid: { type: mongoose.Schema.Types.ObjectId, ref: "users" },
    name: String,
    account_number: String,
    routing_number: String,
    local: { type: mongoose.Schema.Types.ObjectId, ref: "users" },
    wire: { type: mongoose.Schema.Types.ObjectId, ref: "bank_accounts" },
    type: { type: String, enum: ["local", "wire"], default: "local" },
  },
  {
    timestamps: true,
  }
);

module.exports = model("beneficiary", beneficiaryModel);
