const { Schema, default: mongoose, model } = require("mongoose");
const moment = require("moment");

const notification = new Schema(
  {
    uid: {
      type: mongoose.Types.ObjectId,
      ref: "users",
      required: [true, "user id is required"],
    },
    type: {
      type: String,
      enum: ["alert", "info", "success"],
      default: "alert",
    },
    read: {
      type: Boolean,
      default: false,
    },
    body: {
      type: Object,
      title: String,
      text: String,
    },
    date: { type: Date, default: Date.now },
  },
  {
    timestamps: true,
  }
);

module.exports = model("notification", notification);

// create account, "transfer", "reversal",
