const { Schema, model, mongoose, Types } = require("mongoose");
const bcrypt = require("bcryptjs");
const moment = require("moment");

const predictions = new Schema(
  {
    date: { type: Date, default: Date.now },
    uid: { type: mongoose.Schema.Types.ObjectId, ref: "users" },
    is_seed: { type: Boolean, default: false },
    mid: { type: mongoose.Schema.Types.ObjectId, ref: "markets" },
    is_resolved: { type: Boolean, default: false },
    predict: { type: String, enum: ["yes", "no"] },
    amount: { type: Number, default: 0 },
    after_amount: { type: Number, default: 0 },
    winner: { type: String, enum: ["yes", "no"] },
    is_demo: { type: Boolean, default: false },
  },
  {
    timestamps: true,
  }
);

module.exports = model("predictions", predictions);
