const { Schema, model } = require("mongoose");

const userModel = new Schema(
  {
    active: { type: Boolean, default: false },
    is_demo: { type: Boolean, default: false },
    image: String,
    img: Object,
    email: {
      type: String,
      required: [true, "Email address is required"],
    },
    is_email_verified: { type: Boolean, default: false },
    alert: {
      type: Object,
      direction: {
        type: String,
        enum: ["email", "phone"],
        default: "email",
      },
    },
    otp: {
      type: Object,
      code: {
        type: String,
      },
      direction: {
        type: String,
        enum: ["email", "phone", "authenticator"],
        default: "email",
      },
    },
    username: String,
    name: {
      first: String,
      last: String,
    },
    tfa: {
      type: Object,
      required: [true, "2FA sector error"], // Ensure tfa object is provided
      token: {
        type: String,
        default: "", // Default value for token if not provided
      },
      status: {
        type: String,
        enum: ["active", "inactive"],
        default: "inactive", // Default status is 'inactive' if not provided
      },
    },
    phone: {
      type: String,
      required: [true, "phone is required"],
    },
    password: {
      type: String,
      required: [true, "Password is required"],
    },
    suspended: {
      type: Array,
      default: [], //an array of suspended functions for the user
    },
    is_suspended: { type: Boolean, default: false },
    type: {
      type: String,
      enum: ["user", "moderator", "admin", "su"],
      default: "user",
    },
    total_stakes: { type: Number, default: 0 },
    total_demo_stakes: { type: Number, default: 0 },
    win_rate: { type: Number, default: 0 },
    win_demo_rate: { type: Number, default: 0 },
    total_winning: { type: Number, default: 0 },
    total_demo_winning: { type: Number, default: 0 },
    total_prediction: { type: Number, default: 0 },
    total_demo_prediction: { type: Number, default: 0 },
  },
  {
    timestamps: true,
  }
);

module.exports = model("users", userModel);
