const express = require("express");
const ConnectDBAndStartServer = require("./db/connection");
const morgan = require("morgan");
const cors = require("cors");
const expressIp = require("express-ip");
const helmet = require("helmet");
const useragent = require("express-useragent");
const fs = require("fs");
const path = require("path");

const app = express();
const http = require("http");

const server = http.Server(app);
// const WebSocket = require("ws");
// const wss = new WebSocket.Server({ server });
const { DB } = require("./db/index");

require("dotenv").config();

// route manager
const manageUserAccount = require("./routes/account/manageAccount");
const TWOfa = require("./routes/account/2fa");
const manageNotification = require("./routes/account/manageNotification");
const manageFund = require("./routes/account/fund_");
const _Market = require("./routes/account/_market");

const corsOptions = {
  origin: [
    "http://127.0.0.1:5501",
    "http://localhost:5173",
    "http://localhost:5174",
    "http://localhost:3000",
    "http://localhost:3001",
    "http://localhost:5500",
    "http://127.0.0.1:5500",
    "http://tncmarkets.com",
    "https://tncmarkets.com",
    "https://tncmarkets.com/",
    "https://www.tncmarkets.com",
    "http://admin.tncmarkets.com",
    "https://admin.tncmarkets.com",
    "https://admin.tncmarkets.com/",
    "https://www.admin.tncmarkets.com",
  ],
  methods: "GET,HEAD,PUT,PATCH,POST,DELETE,OPTIONS",
  allowedHeaders: ["Content-Type", "Authorization"],
};
// app.use(cors(corsOptions));
app.use(cors("*"));
app.use(morgan("combined"));
app.use(helmet());
app.set("trust proxy", true);
app.use(useragent.express());
app.use(express.urlencoded({ extended: false }));
app.use(express.json());

// middlewares
app.use(
  "/api/user/account",
  manageUserAccount,
  TWOfa,
  manageNotification,
  manageFund,
  _Market
);

const account = require("./routes/su/everything_account");
const everything_funds = require("./routes/su/everything_funds");
const everything_market = require("./routes/su/everything_market");
const metrics = require("./routes/su/metrics");
const user_management = require("./routes/su/user_management");

app.use("/api/su", account, everything_funds, everything_market, metrics, user_management);

// // websocket here
// const websocketHandler = require("./websockets/websockekHandler");
// wss.on("connection", async (ws, req) => websocketHandler(ws, req));

const { initWebSocket } = require("./websockets/websocket");
// Initialize WebSocket server
initWebSocket(server);

ConnectDBAndStartServer(
  server.listen(
    process.env.PORT || 5000,
    console.log(`SERVER STARTED ON PORT ${process.env.PORT}`)
  )
);

// apikey for conversion rate from app.exchangerate-api.com
// 8c9defeb8b3ab18611ad0658
// full url
// https://v6.exchangerate-api.com/v6/8c9defeb8b3ab18611ad0658/latest/USD
// `https://v6.exchangerate-api.com/v6/8c9defeb8b3ab18611ad0658/pair/${mainFrom}/${mainTo}/${amount}` // conversion
//


