const { DB } = require("../../db");
const { BCRYPT } = require("../../helper/bcrypt");
const { verifySession } = require("../../middleware/verifySession");
const Router = require("express").Router();
const { SECURE_TFA, VERIFY_TFA } = require("../../validators/account");
const speakeasy = require("speakeasy");
const qrcode = require("qrcode");
const { sendEmail } = require("../../helper/sendEmail");
const { sendSMS } = require("../../helper/sendSMS");
const { APP_NAME } = require("../../helper/constant");

function filterOnlyFalseFields(obj) {
  return Object.fromEntries(
    Object.entries(obj).filter(([_, value]) => value !== false)
  );
}

//choose how to receive otp
Router.post("/set/2fa", async (req, res) => {
  try {
    let { error, value } = SECURE_TFA.validate(req.body);
    if (error) throw new Error(error.details[0].message);
    //
    let { email, type } = value;

    //  check if user exists
    let emailExists = await DB.USER.findOne({
      email: email,
    }).select(["name", "email", "phone", "_id", "tfa", "otp"]);
    // if not email exist
    if (!emailExists) throw new Error("invalid email combination");

    const secret = speakeasy.generateSecret({
      name: `${APP_NAME}: ${emailExists.username}`,
    });

    const abcd = await qrcode.toDataURL(secret.otpauth_url);

    const code = Math.random().toString(20).split("").splice(2, 6).join("");

    // if (type == "authenticator") {
      if (!abcd) {
        return res.status(500).json({
          msg: "Failed to generate QR code",
        });
      }

      // emailExists.otp = { direction: type };
      emailExists.otp = { direction: "authenticator" };
      emailExists.tfa = { ...emailExists.tfa, token: secret.base32 };

      await emailExists.save();

      res.json({
        qrCode: abcd,
        // secret,
        data: "successful",
      });
      return;
    // }

    // if (type == "email") {
    //   emailExists.otp = { code, direction: type };

    //   await emailExists.save();

    //   // await sendEmail(code, emailExists.name.first, emailExists.email);

    //   res.json({
    //     data: "successful",
    //   });
    //   return;
    // }

    // if (type == "phone") {
    //   const text = `Verify your account with this one time code. Copy the code below to authorize your device using the activation code ${code}`;
    //   await sendSMS(emailExists.phone, text);

    //   emailExists.otp = { code, direction: type };
    //   // emailExists.tfa = { status: "active" };

    //   await emailExists.save();
    //   const to = emailExists.phone;

    //   res.json({
    //     data: "successful",
    //   });
    //   return;
    // }

    // res.json({
    //   msg: "Unsuccessful",
    // });
  } catch (error) {
    console.log(error);

    res.status(500).json({
      msg: error.message || "unable to complete request.",
    });
  }
});

//verify the otp code whether email phone how to receive otp
Router.post("/verify/2fa/code/:sessionID", verifySession, async (req, res) => {
  try {
    const findSee = await DB.SESSION.findById(req.params.sessionID);

    if (!findSee) throw new Error("Invalid Session ID");

    let { error, value } = VERIFY_TFA.validate(req.body);
    if (error) throw new Error(error.details[0].message);
    //
    let { code } = value;

    //  check if user exists
    let emailExists = await DB.USER.findById(req.user._id).select([
      "name",
      "email",
      "phone",
      "_id",
      "tfa",
      "otp",
    ]);
    // if not email exist
    if (!emailExists) throw new Error("Can't find user");

    // if (emailExists.otp.direction == "authenticator") {
      const isValid = speakeasy.totp.verify({
        secret: emailExists.tfa.token,
        encoding: "base32",
        token: code,
      });

      if (!isValid) {
        res.status(500).json({
          msg: "Invalid 2FA token",
        });
        return;
      }

      if (emailExists.tfa.status == "inactive") {
        await DB.USER.findByIdAndUpdate(
          emailExists._id,
          { tfa: { ...emailExists.tfa, status: "active" } },
          { new: true }
        );
      }

      await DB.SESSION.findByIdAndUpdate(
        req.params.sessionID,
        { isAuth: true },
        { new: true }
      );

      res.status(200).json({
        data: "success",
      });

      return;
    // } else {
    //   if (emailExists.otp.code.toLowerCase() !== code?.toLowerCase()) {
    //     res.status(500).json({
    //       msg: "Invalid 2FA token",
    //     });
    //     return;
    //   }

    //   emailExists.tfa = { ...emailExists.tfa, status: "active" };
    //   await emailExists.save();

    //   await DB.SESSION.findByIdAndUpdate(
    //     req.params.sessionID,
    //     { isAuth: true },
    //     { new: true }
    //   );

    //   res.status(200).json({
    //     data: "success",
    //   });
    // }

    // res.status(200).json({
    //   msg: "Unsuccessful",
    // });
  } catch (error) {
    console.log(error);

    res.status(500).json({
      msg: error.message || "unable to complete request.",
    });
  }
});

module.exports = Router;
