const Router = require("express").Router();
const { DB } = require("../../db");
const { verifySession } = require("../../middleware/verifySession");
const joi = require("joi");
var multipart = require("connect-multiparty");
const { sendWithdrawalEmail } = require("../../helper/sendEmail");
var multipartMiddleware = multipart();
var cloudinary = require("cloudinary").v2;

cloudinary.config({
  cloud_name: "dqdndojli",
  api_key: "517252993479136",
  api_secret: "uX_gbq1gKHMO8Bs9txUTOjs1ecM",
  secure: true,
});

const _fund_usdt = joi
  .object({
    address: joi.string().required(),
    trx_id: joi.string(),
    amount: joi.string(),
    code: joi.string(),
    type: joi.string().valid("deposit", "withdrawal").required(),
  })
  .strict();

// user fund with usdt
Router.post(
  "/fund/usdt",
  verifySession,
  multipartMiddleware,
  async (req, res) => {
    try {
      let { error, value } = _fund_usdt.validate(req.body);
      if (error) throw new Error(error.details[0].message);

      const { address, trx_id, type, amount, code } = value;

      if (type == "deposit" && !req?.files?.photo?.path)
        throw new Error("screenshot is required");

      if (type == "deposit" && !trx_id) throw new Error("trx_id is required");

      let uploadingData;
      if (type == "deposit") {
        // upload the image here
        uploadingData = await cloudinary.uploader.upload(
          req?.files?.photo?.path
        );
      }

      if (type == "withdrawal" && !amount)
        throw new Error("amount is required");

      if (type == "withdrawal" && !code) {
        const rancode = Math.random()
          .toString(20)
          .split("")
          .splice(2, 6)
          .join("");
        sendWithdrawalEmail(rancode, req.user.username, req.user.email);

        await DB.USER.findByIdAndUpdate(
          req.user._id,
          {
            otp: {
              code: rancode?.toLowerCase(),
              direction: "email",
            },
          },
          { new: true }
        );

        res.status(201).json({
          data: "Confirm otp before you will continue",
        });

        return;
      }

      if (
        type == "withdrawal" &&
        req.user?.otp?.code.toLowerCase() !== code?.toLowerCase()
      ) {
        res.status(500).json({
          msg: "Invalid code combination",
        });
        return;
      }
      const ref = Math.random().toString(20).split(".")[1];
      // create a new account here if the info do not exist
      let newUser = await DB.DE_WITH.create({
        uid: req.user._id,
        ref,
        address,
        trx_id,
        type,
        method: "usdt",
        amount,
        image: uploadingData.url,
        img: uploadingData,
      });

      res.status(201).json({
        data: { ...newUser._doc, img: null },
      });
    } catch (error) {
      res.status(500).json({
        msg: error.message || "unable to complete request",
      });
    }
  }
);

const _fund_bank = joi
  .object({
    amount: joi.string().required(),
    type: joi.string().valid("deposit", "withdrawal").required(),
    bank: joi.string().required(),
    code: joi.string(),
  })
  .strict();

// user fund with bank
Router.post(
  "/fund/bank",
  verifySession,
  multipartMiddleware,
  async (req, res) => {
    try {
      let { error, value } = _fund_bank.validate(req.body);
      if (error) throw new Error(error.details[0].message);

      const { amount, bank, type, code } = value;

      if (typeof bank === "string") {
        try {
          req.body.bank = JSON.parse(req.body.bank);
        } catch {
          throw new Error("Invalid bank data format — must be valid JSON");
        }
      }

      const rebank = req.body.bank;
      if (
        !rebank ||
        typeof rebank !== "object" ||
        !rebank.name ||
        !rebank.number ||
        !rebank.bank
      ) {
        throw new Error("Bank information (name, number, bank) is required");
      }

      if (type == "deposit" && !req?.files?.photo?.path)
        throw new Error("screenshot is required");

      let uploadingData;
      if (type == "deposit") {
        // upload the image here
        uploadingData = await cloudinary.uploader.upload(
          req?.files?.photo?.path
        );
      }










      
      if (type == "withdrawal" && !code) {
        const rancode = Math.random()
          .toString(20)
          .split("")
          .splice(2, 6)
          .join("");
        sendWithdrawalEmail(rancode, req.user.username, req.user.email);

        await DB.USER.findByIdAndUpdate(
          req.user._id,
          {
            otp: {
              code: rancode?.toLowerCase(),
              direction: "email",
            },
          },
          { new: true }
        );

        res.status(201).json({
          data: "Confirm otp before you will continue",
        });

        return;
      }

      if (
        type == "withdrawal" &&
        req.user?.otp?.code.toLowerCase() !== code?.toLowerCase()
      ) {
        res.status(500).json({
          msg: "Invalid code combination",
        });
        return;
      }












      const ref = Math.random().toString(20).split(".")[1];
      // create a new account here if the info do not exist
      let newUser = await DB.DE_WITH.create({
        uid: req.user._id,
        ref,
        method: "naira",
        amount,
        type,
        bank_details: rebank,
        image: uploadingData?.url,
        img: uploadingData,
      });

      res.status(201).json({
        data: { ...newUser._doc, img: null },
      });
    } catch (error) {
      res.status(500).json({
        msg: error.message || "unable to complete request",
      });
    }
  }
);

// get each user transaction history
Router.get(
  "/transaction/history/:page/:limit",
  verifySession,
  async (req, res) => {
    try {
      if (req.user.is_demo) {
        res.status(201).json({
          data: {
            data: [],
            hasMore: false,
            total_pages: 0,
          },
        });
        return;
      }
      const page = parseInt(req.params?.page) || 1;
      const limit = parseInt(req.params?.limit) || 26;

      const total = await DB.DE_WITH.countDocuments({ uid: req.user._id });
      const total_pages = Math.ceil(total / limit);

      const every_ = await DB.DE_WITH.find({ uid: req.user._id })
        .select("-img")
        .populate("uid", "image email username name")
        .skip((page - 1) * limit)
        .limit(limit + 1)
        .sort({ createdAt: -1 });

      const hasMore = every_.length > limit;
      if (hasMore) every_.pop(); // remove the extra item

      res.status(201).json({
        data: {
          data: every_,
          hasMore,
          total_pages,
        },
      });
    } catch (error) {
      res.status(500).json({
        msg: error.message || "unable to complete request",
      });
    }
  }
);

module.exports = Router;
