const { DB } = require("../../db");
const Router = require("express").Router();
const { verifyAdmin } = require("../../middleware/verifyAdmin");
const { verifySession } = require("../../middleware/verifySession");
const joi = require("joi");

const CREATE_ADMIN = joi
  .object({
    email: joi.string().email().required(),
    type: joi.string().valid("user", "moderator", "admin", "su").required(),
  })
  .strict();

// CREATE admin ACCOUNT or remove ADMIN
Router.post("/toggle/position", verifySession, verifyAdmin, async (req, res) => {
  try {
    let { error, value } = CREATE_ADMIN.validate(req.body);
    if (error) throw new Error(error.details[0].message);
    //
    let { email, type } = value;

    // find email account here
    const findAccount = await DB.USER.findOne({ email });

    if (!findAccount)
      throw new Error("Account must be a user before you can continue");

    // now update the found account with the type
    const updated = await DB.USER.findByIdAndUpdate(
      findAccount._id,
      { type },
      { new: true }
    );

    res.status(201).json({
      data: "Success",
    });
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
  }
});

module.exports = Router;
