const { Schema, model, default: mongoose } = require("mongoose");
const moment = require("moment");

const app_settings = new Schema(
  {
    date: { type: Date, default: Date.now },
    app_percentage: Number,
    exchange_rate: Number,
    platform_name: String,
    platform_description: String,
    platform_email: String,
    support_email: String,
    maintenance_mode: { type: Boolean, default: false },
  },
  {
    timestamps: true,
  }
);

module.exports = model("app_settings", app_settings);
