const { Schema, model, default: mongoose } = require("mongoose");
const moment = require("moment");

const comments = new Schema(
  {
    date: { type: Date, default: Date.now },
    uid: { type: mongoose.Schema.Types.ObjectId, ref: "users" },
    mid: { type: mongoose.Schema.Types.ObjectId, ref: "markets" },
    content: String,
    replying_to: { type: Schema.Types.ObjectId, ref: "comments" }, // for replies
    reactions: [
      {
        uid: { type: Schema.Types.ObjectId, ref: "users" },
        reaction: String, // e.g. "👍", "❤️"
      },
    ],
  },
  {
    timestamps: true,
  }
);

module.exports = model("comments", comments);
