const { Schema, model, default: mongoose } = require("mongoose");
const moment = require("moment");

const deposit_withdrawals = new Schema(
  {
    uid: { type: mongoose.Schema.Types.ObjectId, ref: "users" },
    ref: String,
    address: String,
    amount: { type: Number, default: 0 },
    bank_details: { type: Object, name: String, number: String, bank: String },
    trx_id: String,
    date: { type: Date, default: Date.now },
    method: {
      type: String,
      enum: ["usdt", "naira"],
      default: "usdt",
    },
    image: String,
    img: Object,
    status: {
      type: String,
      enum: ["pending", "completed", "cancelled"],
      default: "pending",
    },
    type: {
      type: String,
      enum: ["deposit", "withdrawal"],
      default: "deposit",
    },
  },
  {
    timestamps: true,
  }
);

module.exports = model("deposit_withdrawals", deposit_withdrawals);
