const { Schema, model, default: mongoose } = require("mongoose");
const moment = require("moment");

const markets = new Schema(
  {
    date: { type: Date, default: Date.now },
    end_date: { type: Date },
    title: String,
    description: String,
    category: String,
    image: String,
    is_resolved: { type: Boolean, default: false },
    who_won: String,
    img: Object,
    min: Number,
    max: Number,
    rules: String,
    has_seed: { type: Boolean, default: false },
    yes_seed: Number,
    no_seed: Number,
  },
  {
    timestamps: true,
  }
);

module.exports = model("markets", markets);
