const { Schema, model, mongoose, Types } = require("mongoose");
const bcrypt = require("bcryptjs");
const moment = require("moment");

const wallets = new Schema(
  {
    uid: {
      type: Types.ObjectId,
      ref: "users",
    },
    on_hold: { type: Number, default: 0 },
    is_demo: { type: Boolean, default: false },
    pending: { type: Number, default: 0 },
    usdt_balance: { type: Number, default: 0 },
    total_subtracted: { type: Number, default: 0 },
    total_balance: { type: Number, default: 0 },
    date: { type: String, default: moment().format("lll") },
  },
  {
    timestamps: true,
  }
);

module.exports = model("user_wallets", wallets);
