const Router = require("express").Router();
const { DB } = require("../../db");
const { verifySession } = require("../../middleware/verifySession");
const { VIEW_NOTIFICATION } = require("../../validators/account");

// view and read all nots
Router.get(
  "/all/notifications/:page/:limit",
  verifySession,
  async (req, res) => {
    try {
      const page = parseInt(req.params.page) || 1;
      const limit = parseInt(req.params?.limit) || 26;

      const total = await DB.NOTIFICATION.countDocuments({ uid: req.user._id });
      const total_pages = Math.ceil(total / limit);

      const every_ = await DB.NOTIFICATION.find({ uid: req.user._id })
        .skip((page - 1) * limit)
        .limit(limit + 1)
        .sort({ createdAt: -1 });

      const hasMore = every_.length > limit;
      if (hasMore) every_.pop(); // remove the extra item

      res.status(201).json({
        data: {
          data: every_,
          hasMore,
          total_pages,
        },
      });
    } catch (error) {
      res.status(500).json({
        msg: error.message || "unable to complete request",
      });
      console.log(error);
    }
  }
);

// view and read all nots
Router.post("/read/notifications", verifySession, async (req, res) => {
  try {
    let { error, value } = VIEW_NOTIFICATION.validate(req.body);
    if (error) throw new Error(error.details[0].message);

    const { ids } = value;

    // view and read all nots
    await DB.NOTIFICATION.updateMany(
      { _id: { $in: ids } }, // Filter criteria
      { $set: { read: true } } // Update object
    );

    res.status(201).json({
      data: "Successful",
    });
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
    console.log(error);
  }
});

// delete nots
Router.delete("/delete/notifications", verifySession, async (req, res) => {
  try {
    let { error, value } = VIEW_NOTIFICATION.validate(req.body);
    if (error) throw new Error(error.details[0].message);

    const { ids } = value;

    // delete all nots
    await DB.NOTIFICATION.deleteMany({
      _id: { $in: ids },
    });

    res.status(201).json({
      data: "Successful",
    });
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
    console.log(error);
  }
});

module.exports = Router;
