const joi = require("joi");

const VALIDATE_BANK_ACCOUNT_SCHEMA = joi
  .object({
    account_number: joi.string().min(6).max(14).required(),
    account_nickname: joi.string().min(3),
    routing_number: joi.string(),
    account_name: joi.string().min(3).required(),
    // country: joi.string().min(3).required(),
    address: joi.object().required(),
    // city: joi.string().min(3).required(),
    // state: joi.string().min(3).required(),
    // zip_code: joi.string().min(2).required(),
    sort_code: joi.string().min(3).required(),
    account_currency: joi.string(),
    bank_name: joi.string().required(),
    iban: joi.string().required(),
    note: joi.string(),
  })
  .strict();

const VALIDATE_EDIT_BANK_ACCOUNT_SCHEMA = joi
  .object({
    account_number: joi.string().min(6).max(14),
    account_nickname: joi.string().min(3),
    routing_number: joi.string(),
    account_name: joi.string().min(3),
    // country: joi.string().min(3),
    address: joi.object().required(),
    // city: joi.string().min(3),
    // region: joi.string().min(3),
    // zip_code: joi.string().min(2),
    sort_code: joi.string().min(3),
    account_currency: joi.string(),
    bank_name: joi.string(),
    note: joi.string(),
  })
  .strict();

module.exports = {
  VALIDATE_BANK_ACCOUNT_SCHEMA,
  VALIDATE_EDIT_BANK_ACCOUNT_SCHEMA,
};
