const joi = require("joi");

const ACCEPTED_TRANSFER_SCHEMA = joi
  .object({
    otp: joi.string().required(),
    bankID: joi.string(),
    receiverID: joi.string(),
    amount: joi.string().required(),
    memo: joi.string(),
    transfer_type: joi.string().valid("local", "wire").required(),
    transfer_from: joi.string().valid("usd", "gbp", "euro").required(),
    charges: joi.string(),
    type: joi.string().valid("credit", "debit").default("debit").required(),
  })
  .strict();

const FIND_BANK_SCHEMA = joi
  .object({
    account_number: joi.string().required(),
    routing_number: joi.string(),
    type: joi.string().valid("local", "wire").default("local").required(),
  })
  .strict();

const POST_BENEFICIARY = joi
  .object({
    account_number: joi.string().required(),
    routing_number: joi.string(),
    _id: joi.string().required(),
    name: joi.string(),
    type: joi.string().valid("local", "wire").default("local").required(),
  })
  .strict();

  
  const INTERNAL_TRANSFER = joi.object({
    amount: joi.string().required(),
    from: joi.string().valid("usd", "gbp", "euro").default("usd").required(),
    to: joi.string().valid("usd", "gbp", "euro").default("usd").required(),
  })
  .strict();

module.exports = {
  ACCEPTED_TRANSFER_SCHEMA,
  FIND_BANK_SCHEMA,
  POST_BENEFICIARY,
  INTERNAL_TRANSFER,
};
