const { Schema, model, default: mongoose } = require("mongoose");
const moment = require("moment");

const app_commissions = new Schema(
  {
    date: { type: Date, default: Date.now },
    app_percentage: Number,
    commission: Number,
    total_volume: Number,
    yes_predictions: Number,
    yes_value: Number,
    no_predictions: Number,
    no_value: Number,
    winning_side: String,
    mid: {
      type: mongoose.Types.ObjectId,
      ref: "markets",
      required: [true, "market id is required"],
    },
  },
  {
    timestamps: true,
  }
);

module.exports = model("app_commissions", app_commissions);
