const { Schema, model, default: mongoose } = require("mongoose");
const moment = require("moment");

const TransactionModel = new Schema(
  {
    uid: { type: mongoose.Schema.Types.ObjectId, ref: "users" },
    // balance_after_debit: String,
    ref: String,
    bankID: { type: mongoose.Schema.Types.ObjectId, ref: "bank_accounts" },
    receiverID: { type: mongoose.Schema.Types.ObjectId, ref: "users" },
    amount: Number,
    memo: String, //narration of transfer 
    repeat: { type: Object, 
      frequency: String,
      duration: String,
     },
    transfer_type: { type: String, enum: ["local", "wire"], default: "local" },
    transfer_from: { type: String, enum: ["usd", "gbp", "euro"], default: "usd" },
    charges: Number,
    date: { type: Date, default: Date.now },
    status: {
      type: String,
      enum: ["pending", "successful", 'rejected', 'reversed'],
      default: "successful",
    },
    type: {
      type: String,
      enum: ['credit','debit'],
      default: "credit",
    },
  },
  {
    timestamps: true,
  }
);

module.exports = model("Transactions", TransactionModel);