const { DB } = require("../db");

const verifySession = async (req,res,next) => {
    try {
        if(!req.headers.authorization) throw new Error('invalid user in session')
        let token = req.headers.authorization.replace('bearer ', '').replace('Bearer ', '');
        if(!token) throw new Error('invalid user in session, login to continue request');
        // if the token exists 
        let sessionIDExist = await DB.SESSION.findOne({_id:token,status: 'active'}).populate('uid');
        if(!sessionIDExist) throw new Error('invalid user in session');
 
        req.user = sessionIDExist.uid;
        next(); // move to the next section
    } catch (error) {
        res.status(500).json({
            msg: error.message || 'unable to complete request'
        })
    }
}

module.exports = {verifySession}