const { DB } = require("../../db");
const { BCRYPT } = require("../../helper/bcrypt");
const { BLOCK_TRANSFER } = require("../../helper/constant");
const {
  generateUniqueAccountNumber,
} = require("../../helper/generateAccountNumber");
const {
  sendEmail,
  sendPasswordChangedEmail,
  createAccountEmail,
  sendForGottenEmail,
} = require("../../helper/sendEmail");
// const { sendSMS } = require("../../helper/sendSMS");
const checkUserSuspensionStatusWith = require("../../helper/validateSuspension");
const { verifyAdmin } = require("../../middleware/verifyAdmin");
const { verifySession } = require("../../middleware/verifySession");
const {
  ACCEPTED_CREATE_ACCOUNT_SCHEMA,
  ACCEPTED_LOGIN_ACCOUNT_SCHEMA,
  ACCEPTED_FORGOT_PWD_ACCOUNT_SCHEMA,
  ACCEPTED_CHANGE_PWD_ACCOUNT_SCHEMA,
} = require("../../validators/account");
const fs = require("fs");
const path = require("path");
var multipart = require("connect-multiparty");
var multipartMiddleware = multipart();
var cloudinary = require("cloudinary").v2;
const joi = require("joi");
const lowerCase = require("../../middleware/convert_lowercase");

cloudinary.config({
  cloud_name: "dqdndojli",
  api_key: "517252993479136",
  api_secret: "uX_gbq1gKHMO8Bs9txUTOjs1ecM",
  secure: true,
});

const Router = require("express").Router();
const { getWss } = require("../../websockets/websocket");
const { sendToUser } = require("../../middleware/sendToUser");

function filterOnlyFalseFields(obj) {
  return Object.fromEntries(
    Object.entries(obj).filter(([_, value]) => value !== false)
  );
}

// CREATE USER ACCOUNT
Router.post("/create", lowerCase, async (req, res) => {
  try {
    let { error, value } = ACCEPTED_CREATE_ACCOUNT_SCHEMA.validate(req.body);
    if (error) throw new Error(error.details[0].message);

    // check if the user email or phone already exists
    let { email, phone, password, username, name } = req.body;

    // extract from db

    let userInfoExists = await DB.USER.findOne({
      $or: [{ email }, { phone }, { username }],
    }).select(["phone", "email", "username"]);

    if (userInfoExists)
      throw new Error(
        userInfoExists._doc.phone === phone
          ? "Phone belongs to an existing account"
          : userInfoExists._doc.username === username
          ? "Username belongs to an existing account."
          : "Email belongs to an existing account."
      );

    const code = Math.random().toString(20).split("").splice(2, 6).join("");
    // create a new account here if the info do not exist
    let newUser = await DB.USER.create({
      ...req.body,
      password: await BCRYPT.hashPassword(password),
      otp: {
        code,
        direction: "email",
      },
      tfa: {
        token: null,
        status: "inactive",
      },
    });

    sendEmail(code, newUser.username, newUser.email);
    // createAccountEmail(newUser.username, newUser.email, req.body.password);

    res.status(201).json({
      // data: newUser._id,
      data: "account creation process completed",
    });

    sendToUser(newUser._id?.toString(), {
      type: "ACCOUNT_NOTIFICATION",
      payload: {
        type: "alert",
        body: {
          title: "Account Creation Success",
          text: "🎉 Success! Your account has been created. Welcome aboard!",
        },
      },
    });

    await DB.NOTIFICATION.create({
      uid: newUser._id,
      type: "alert",
      body: {
        title: "Account Creation Success",
        // READING AND REPLACING WHERE {{NAME FOR THE REAL NAME}} ALL THE FILE SYSTEM
        text: "🎉 Success! Your account has been created. Welcome aboard!",

        // CHANGING ALL THE FILE SYSTEM
        // text: fs.writeFileSync(path.join(process.cwd()+"/messages/welcome.txt" ) , 'this is the change i wanted to show you')
      },
    });

    // email cl of the info created
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request.",
    });
  }
});

const RESENDEMAIL_ = joi
  .object({
    email: joi.string().email().required(),
  })
  .strict();

// RESEND CODE HERE
Router.put("/resend/email", lowerCase, async (req, res) => {
  try {
    let { error, value } = RESENDEMAIL_.validate(req.body);
    if (error) throw new Error(error.details[0].message);

    // check if the user email or phone already exists
    let { email } = req.body;

    const findUserFess = await DB.USER.findOne({ email });

    if (!findUserFess)
      throw new Error("Unable to complete request, check email and continue");

    const code = Math.random().toString(20).split("").splice(2, 6).join("");
    sendEmail(code, findUserFess.username, findUserFess.email);

    let resett = await DB.USER.findByIdAndUpdate(findUserFess._id, {
      otp: {
        code,
        direction: "email",
      },
    });

    res.status(201).json({
      data: "Success",
    });

    // email cl of the info created
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request.",
    });
  }
});

const verify_code = joi
  .object({
    email: joi.string().email().required(),
    code: joi.string().required(),
  })
  .strict();

//verify_code for email
Router.post("/verify_email", lowerCase, async (req, res) => {
  try {
    let { error, value } = verify_code.validate(req.body);
    if (error) throw new Error(error.details[0].message);

    let { email, code } = value;
    let emailExists = await DB.USER.findOne({
      email: email,
    }).select("email username phone password _id tfa otp");

    // if not email exist
    if (!emailExists) throw new Error("Invalid code combination");

    if (emailExists?.otp?.code.toLowerCase() !== code?.toLowerCase()) {
      res.status(500).json({
        msg: "Invalid code combination",
      });
      return;
    }

    await DB.USER.findByIdAndUpdate(
      emailExists._id,
      { is_email_verified: true },
      { new: true }
    );

    // delete all existing sessions if the user session pass 3
    let allUserSessions = await DB.SESSION.find({ uid: emailExists._id });

    if (allUserSessions.length > 0) {
      // delete all sessions to manage db
      await DB.SESSION.deleteMany({ uid: emailExists._id.toString() });
    }

    // create a session
    let newSession = await DB.SESSION.create({
      uid: emailExists._id,
      ip: req.ip,
      device: filterOnlyFalseFields(req.useragent),
      isAuth: emailExists.tfa.status === "active" ? false : true,
    });

    res.json({
      data: newSession._id,
    });

    // email cl of the info created
  } catch (error) {
    console.log("error =>>> ", error);

    res.status(500).json({
      msg: error.message || "unable to complete request.",
    });
  }
});

//login
Router.post("/login", lowerCase, async (req, res) => {
  try {
    let { error, value } = ACCEPTED_LOGIN_ACCOUNT_SCHEMA.validate(req.body);
    if (error) throw new Error(error.details[0].message);
    //
    let { email, password } = value;
    //  check if user exists
    let emailExists = await DB.USER.findOne({
      email: email,
    }).select(
      "email username phone password _id tfa otp is_email_verified type"
    );

    // if not email exist
    if (!emailExists)
      throw new Error("invalid username and password combination");

    let pwdMatch = await BCRYPT.compareHash(password, emailExists.password);

    if (!pwdMatch) throw new Error("invalid username and password combination");

    if (!emailExists.is_email_verified) {
      res.status(400).json({
        msg: "Please verify your email and continue",
        isEmailVerified: false,
      });
      return;
    }
    // delete all existing sessions if the user session pass 3
    let allUserSessions = await DB.SESSION.find({ uid: emailExists._id });

    if (allUserSessions.length > 0) {
      // delete all sessions to manage db
      await DB.SESSION.deleteMany({ uid: emailExists._id.toString() });
    }

    // create a session
    let newSession = await DB.SESSION.create({
      uid: emailExists._id,
      ip: req.ip,
      device: filterOnlyFalseFields(req.useragent),
      isAuth: emailExists.tfa.status === "active" ? false : true,
    });

    sendToUser(emailExists._id?.toString(), {
      type: "ACCOUNT_NOTIFICATION",
      payload: {
        type: "alert",
        body: {
          title: "Account Login",
          text: `New login from device ${newSession.device?.browser} on ${newSession.device?.platform}`,
        },
      },
    });

    await DB.NOTIFICATION.create({
      uid: emailExists._id,
      type: "alert",
      body: {
        title: "Account Login",
        text: `New login from device ${newSession.device?.browser} on ${newSession.device?.platform}`,
      },
    });

    // const code = Math.random().toString(20).split("").splice(2, 6).join("");
    // const text = `Verify your account with this one time code. Copy the code below to authorize your device using the activation code ${code}`;

    // if (emailExists.tfa.status == "active") {
    //   if (emailExists.otp.direction === "email") {
    //     emailExists.otp = { code, direction: "email" };
    //     await emailExists.save();

    //     // send NOTIFICATION DETAILS from EMAIL
    //     await sendEmail(code, emailExists.username, emailExists.email);
    //   }

    //   // if (emailExists.otp.direction === "phone") {
    //   //   emailExists.otp = { code, direction: "phone" };
    //   //   await emailExists.save();

    //   //   // send NOTIFICATION DETAILS from PHONE
    //   //   await sendSMS(emailExists.phone, text);
    //   // }
    // }

    res.json({
      data: newSession._id,
      is_admin: emailExists?.type == "user" ? false : true,
      isEmailVerified: true,
    });
  } catch (error) {
    console.log(error);

    res.status(500).json({
      msg: error.message || "unable to complete request.",
    });
  }
});

// logout session HERE
Router.get("/logout/session/:id", async (req, res) => {
  try {
    await DB.SESSION.findByIdAndDelete(req.params.id);
    res.json({
      data: "success",
    });
  } catch (error) {
    console.log(error);

    res.status(500).json({
      msg: error.message || "unable to complete request.",
    });
  }
});

// verify session
Router.get("/session/:id", async (req, res) => {
  try {
    const findSession = await DB.SESSION.findById(req.params.id);
    if (!findSession)
      throw new Error("Can't find session with the required ID");

    res.json({
      data: findSession,
    });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
  }
});

// view profile
Router.get("/profile", verifySession, async (req, res) => {
  try {
    await checkUserSuspensionStatusWith(req.user._id, BLOCK_TRANSFER);
    let userInSession = await DB.USER.findOne({ _id: req.user._id }).select(
      "-password -tfa.token -otp"
    );

    // check if its a demo account
    const is_demo = userInSession.is_demo;

    if (is_demo) {
      // now get the user wallet details
      const getWallet = await DB.WALLET.findOne({
        uid: req.user._id,
        is_demo: true,
      });

      const balance = getWallet
        ? getWallet.usdt_balance - getWallet.on_hold
        : 0;

      res.json({ data: userInSession, balance });

      return;
    }

    // now get the user wallet details
    const getWallet = await DB.WALLET.findOne({
      uid: req.user._id,
      is_demo: false,
    });

    const balance = getWallet ? getWallet.usdt_balance - getWallet.on_hold : 0;

    res.json({ data: userInSession, balance });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
  }
});

// forgot pwd
Router.put("/password/reset", lowerCase, async (req, res) => {
  try {
    let { error, value } = ACCEPTED_FORGOT_PWD_ACCOUNT_SCHEMA.validate(
      req.body
    );
    if (error) throw new Error(error.details[0].message);
    let userExist = await DB.USER.findOne({ email: value.email });
    if (!userExist)
      throw new Error("invalid email provided, account not founded");
    // email pwd here
    const code = Math.random().toString(20).split("").splice(2, 6).join("");
    sendForGottenEmail(code, userExist.username, userExist.email);

    // update the account here
    await DB.USER.findByIdAndUpdate(
      userExist._id,
      {
        password: await BCRYPT.hashPassword(code),
      },
      { new: true }
    );

    // reset here
    res.status(201).json({
      data: "password reset is successful, check your email to continue",
    });
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
  }
});

// change pwd
Router.put("/change/password", verifySession, lowerCase, async (req, res) => {
  try {
    let { error, value } = ACCEPTED_CHANGE_PWD_ACCOUNT_SCHEMA.validate(
      req.body
    );
    if (error) throw new Error(error.details[0].message);

    let pwdMatch = await BCRYPT.compareHash(
      value.old_password,
      req.user.password
    );
    if (!pwdMatch) throw new Error("Invalid old password combination");

    await DB.USER.findByIdAndUpdate(
      req.user._id,
      { password: await BCRYPT.hashPassword(value.password) },
      { new: true }
    );
    const code = Math.random().toString(20).split("").splice(2, 6).join("");

    sendPasswordChangedEmail(code, req.user.username, req.user.email);

    sendToUser(req.user._id?.toString(), {
      type: "ACCOUNT_NOTIFICATION",
      payload: {
        type: "info",
        body: {
          title: "Password Changed Successfully",
          text: "Your password was changed successfully. If you did not make this change, please reset your password immediately or contact support.",
        },
      },
    });

    await DB.NOTIFICATION.create({
      uid: req.user._id,
      type: "info",
      body: {
        title: "Password Changed Successfully",
        text: "Your password was changed successfully. If you did not make this change, please reset your password immediately or contact support.",

        // CHANGING ALL THE FILE SYSTEM
        // text: fs.writeFileSync(path.join(process.cwd()+"/messages/welcome.txt" ) , 'this is the change i wanted to show you')
      },
    });

    // email pwd here
    // reset here
    res.status(201).json({
      data: "password change completed",
    });
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
  }
});

// switch to a demo account
Router.put("/toggle/account/type", verifySession, async (req, res) => {
  try {
    const findUser = await DB.USER.findById(req.user._id);
    const account_type = findUser.is_demo;

    // first find if the account already has wallet for demo... if not create with 100 usd as default
    const findDemoWallet = await DB.WALLET.findOne({
      uid: findUser._id,
      is_demo: true,
    });

    if (!findDemoWallet) {
      await DB.WALLET.create({
        is_demo: true,
        uid: findUser._id,
        usdt_balance: 100,
      });
    }

    // toggle account here!
    await DB.USER.findByIdAndUpdate(
      findUser._id,
      { is_demo: !account_type },
      { new: true }
    );

    sendToUser(req.user._id?.toString(), {
      type: "ACCOUNT_NOTIFICATION",
      payload: {
        type: "alert",
        body: {
          title: account_type
            ? "Activated live account"
            : "Activated demo account",
          text: account_type
            ? "Your account has been switched from Live to Demo. You can now continue practicing in a risk-free environment."
            : "Your account has been switched from Demo to Live. You can now trade with real funds.",
        },
      },
    });

    await DB.NOTIFICATION.create({
      uid: req.user._id,
      type: "alert",
      body: {
        title: account_type
          ? "Activated live account"
          : "Activated demo account",
        text: account_type
          ? "Your account has been switched from Live to Demo. You can now continue practicing in a risk-free environment."
          : "Your account has been switched from Demo to Live. You can now trade with real funds.",
      },
    });

    res.status(201).json({
      data: account_type ? "Activated live account" : "Activated demo account",
    });
  } catch (error) {
    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
  }
});

Router.put("/fund/demo/account", verifySession, async (req, res) => {
  try {
    // first find if the account already has wallet for demo... if not create with 100 usd as default
    const findDemoWallet = await DB.WALLET.findOne({
      uid: req.user._id,
      is_demo: true,
    });

    if (!findDemoWallet) {
      await DB.WALLET.create({
        is_demo: true,
        uid: req.user._id,
        usdt_balance: 100,
      });

      res.status(201).json({
        data: "Funded demo account successfully",
      });
      return;
    }

    // toggle account here!
    await DB.WALLET.findByIdAndUpdate(
      findDemoWallet._id,
      { usdt_balance: 100 },
      { new: true }
    );

    sendToUser(req.user._id?.toString(), {
      type: "FUNDED_DEMO_ACCOUNT",
      payload: { amount: "100" },
    });


    // Broadcast safely
    // wss.clients.forEach(client => {
    //   if (client.readyState === 1) {
    //     client.send(JSON.stringify({
    //       type: "MARKET_CREATED",
    //       payload: market
    //     }));
    //   }
    // });

    res.status(201).json({
      data: "Funded demo account successfully",
    });
    // now
  } catch (error) {
    console.log("error =>> ", error);

    res.status(500).json({
      msg: error.message || "unable to complete request",
    });
  }
});

module.exports = Router;
