const joi = require("joi");
const {
  BLOCK_LOGIN,
  BLOCK_OTP,
  BLOCK_TRANSFER,
} = require("../helper/constant");

const SUSPENDED_SCHEMA = joi
  .object({
    suspended: joi
      .string()
      .valid(BLOCK_LOGIN, BLOCK_OTP, BLOCK_TRANSFER)
      .required(),
  })
  .strict();

const EDIT_TRANSACTION = joi
  .object({
    amount: joi.number().required(),
    memo: joi.string().required(),
    date: joi.date().required(),
    status: joi
      .string()
      .valid("pending", "successful", "rejected", "reversed")
      .default("successful")
      .required(),
    suspended: joi
      .string()
      .valid(BLOCK_LOGIN, BLOCK_OTP, BLOCK_TRANSFER)
      .required(),
  })
  .strict();

module.exports = { SUSPENDED_SCHEMA, EDIT_TRANSACTION };
