const { DB } = require("../db/index");
const moment = require("moment");

const getuserdetails = async (ws, data) => {
  let userInSession = await DB.USER.findOne({ _id: data._id }).select(
    "-password -tfa.token -otp"
  );

  // check if its a demo account
  const is_demo = userInSession.is_demo;

  const getWallet = await DB.WALLET.findOne({
    uid: userInSession._id,
    is_demo,
  });

  const balance = getWallet ? getWallet.usdt_balance - getWallet.on_hold : 0;

  ws.send(
    JSON.stringify({
      type: "USER_INFORMATION",
      data: {
        ...userInSession?._doc,
        balance,
      },
    })
  );
};

module.exports = getuserdetails;
