const { DB } = require("../db/index");

const getuserdetails = require("./getuserdetails");

const userSockets = new Map();
const chatRooms = new Map();

function leaveChatRoom(ws) {
  if (ws.chatId && chatRooms.has(ws.chatId)) {
    chatRooms.get(ws.chatId).delete(ws);
    if (chatRooms.get(ws.chatId).size === 0) {
      chatRooms.delete(ws.chatId);
    }
  }
  ws.chatId = null;
  // ws.userId = null;
}

const websocketHandler = async (ws, req) => {
  const url = new URL(req.url, `http://${req.headers.host}`);
  const paramsToken = url.searchParams.get("token");

  if (!paramsToken) {
    ws.close(1008, "Missing token");
    return;
  }

  const IDExist = await DB.SESSION.findOne({
    _id: paramsToken,
    status: "active",
  }).populate("uid");

  if (!IDExist) {
    ws.send(JSON.stringify({ error: true, message: "Invalid session" }));
    ws.close(1008, "Invalid session");
    return;
  }

  const user = IDExist.uid;
  const userId = String(user._id);
  ws.userId = userId;

  // Connection limits
  const MAX_CONNECTIONS_PER_USER = 5;

  if (
    userSockets.has(userId) &&
    userSockets.get(userId).size >= MAX_CONNECTIONS_PER_USER
  ) {
    const sockets = Array.from(userSockets.get(userId));
    sockets[0].close(1008, "Too many connections");
    ws.close(1008, "Too many connections");
    return;
  }

  // Register the connection
  if (!userSockets.has(userId)) {
    userSockets.set(userId, new Set());
  }
  userSockets.get(userId).add(ws);

  // Mark user active
  await DB.USER.findByIdAndUpdate(userId, { active: true });

  // Send initial data automatically
  await getuserdetails(ws, user);

  const messageHandler = async (message) => {
    try {
      const data = JSON.parse(message);
      const { action, token, payload } = data;

      if (!token) {
        ws.send(
          JSON.stringify({
            data: "Missing token",
            error: true,
          })
        );
        ws.close(1008, "Missing token");
        return;
      }
      // check if the session is still active before anything
      let sessionIDExist = await DB.SESSION.findOne({
        _id: token,
        status: "active",
      }).populate("uid");

      let maindata = sessionIDExist?.uid;
      if (!maindata) {
        ws.send(
          JSON.stringify({
            data: "invalid user provided",
            error: true,
          })
        );
        return;
      }

      // if (action === "getuserdetails") {
      //   const userId = user._id; // however you extract it

      //   // set the user online
      //   await DB.USER.findByIdAndUpdate(maindata._id, { active: true });

      //   ws.userId = userId;

      //   // 🔹 ADD CONNECTION LIMIT CHECK HERE 🔹
      //   const MAX_CONNECTIONS_PER_USER = 5;
      //   if (
      //     userSockets.has(String(userId)) &&
      //     userSockets.get(String(userId)).size >= MAX_CONNECTIONS_PER_USER
      //   ) {
      //     // Close oldest connection or reject new one
      //     const sockets = Array.from(userSockets.get(String(userId)));
      //     sockets[0].close(1008, "Too many connections");

      //     // Optional: Send error message to the new connection before closing it
      //     ws.send(
      //       JSON.stringify({
      //         error: true,
      //         message:
      //           "Too many active connections. Please close other sessions.",
      //       })
      //     );
      //     ws.close(1008, "Too many connections");
      //     return; // Stop further processing
      //   }
      //   // 🔹 END OF CONNECTION LIMIT CHECK 🔹
      //   // 🔹 END OF CONNECTION LIMIT CHECK 🔹
      //   // 🔹 END OF CONNECTION LIMIT CHECK 🔹

      //   if (!userSockets.has(String(userId))) {
      //     // console.log("ADDED STUFF HERE!!!");
      //     // console.log("ADDED STUFF HERE!!!", String(userId));
      //     // console.log("ADDED STUFF HERE!!! =>>> ", Math.random());
      //     // console.log("ADDED STUFF HERE!!!");
      //     // console.log("ADDED STUFF HERE!!!");

      //     userSockets.set(String(userId), new Set());
      //   }
      //   userSockets.get(String(userId)).add(ws);

      //   // 🔹 Call it immediately once
      //   await getuserdetails(ws, maindata);
      // }
      if (action === "rebringuserdetails") {
        await getuserdetails(ws, maindata);
      }
    } catch (error) {
      console.error("Error from catch in websocket:", error);
    }
  };

  const closeHandler = async () => {
    leaveChatRoom(ws);

    if (ws.userId) {
      const sockets = userSockets.get(ws.userId);

      await DB.USER.findByIdAndUpdate(ws.userId, {
        active: false,
      });

      if (sockets) {
        sockets.delete(ws);
        if (sockets.size === 0) {
          userSockets.delete(ws.userId);
        }
      }
      console.log(`Cleaned up socket for user ${ws.userId}`);
    }
  };

  const errorHandler = async (error) => {
    leaveChatRoom(ws);

    await DB.USER.findByIdAndUpdate(ws.userId, {
      active: false,
    });

    if (ws.userId) {
      const userId = ws.userId;
      console.log("on error userId =>> ", userId);

      if (userSockets.has(userId)) {
        userSockets.get(userId).delete(ws);
        if (userSockets.get(userId).size === 0) {
          userSockets.delete(userId);
        }
      }
      console.log(`Socket closed for user ${userId}`);
    }
    console.error(`WebSocket error: ${error}`);
  };

  // Add event listeners
  ws.on("message", messageHandler);
  ws.on("close", closeHandler);
  ws.on("error", errorHandler);

  // Cleanup function to remove listeners
  ws.cleanup = () => {
    ws.removeListener("message", messageHandler);
    ws.removeListener("close", closeHandler);
    ws.removeListener("error", errorHandler);
  };

  //   ws.isAlive = true;
  //   ws.on("pong", () => {
  //     ws.isAlive = true;
  //   });

  // Add to your websocketHandler
  //   const interval = setInterval(() => {
  //     if (ws.isAlive === false) {
  //       ws.terminate();
  //       return;
  //     }

  //     ws.isAlive = false;
  //     ws.ping();
  //   }, 30000);

  // Add cleanup when connection closes
  //   ws.on("close", async () => {
  //     clearInterval(interval);

  //     if (ws.cleanup) {
  //       if (ws.userId) {
  //         await DB.USER.findByIdAndUpdate(ws.userId, {
  //           active: false,
  //         });
  //       }

  //       ws.cleanup();
  //     }
  //   });
};

// module.exports = websocketHandler;
module.exports = { websocketHandler, userSockets };
